% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{print.BayesPET_fit}
\alias{print.BayesPET_fit}
\title{Print method for BayesPET model fitting objects}
\usage{
\method{print}{BayesPET_fit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"BayesPET_fit"} returned by \code{\link{fit_models}}.}

\item{\dots}{Additional arguments passed to methods. Not used.}
}
\value{
The object \code{x}, invisibly.
}
\description{
Displays a concise overview of an object of class \code{"BayesPET_fit"},
including whether the analysis is blinded, the number of posterior draws,
and the model components.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
example_enroll <- data_example$example_enroll
example_eventcensor <- data_example$example_eventcensor

# Blinded analysis
example_eventcensor.blind <- example_eventcensor
example_eventcensor.blind$trt <- NA
## Use 2 chains and iter = 2000 here to reduce runtime for the example;
## use more chains in real analyses.
fit.blind <- fit_models(
  data.enroll = example_enroll,
  data.eventcensor = example_eventcensor.blind,
  blinded = TRUE, p_trt = 0.5,
  chains = 2, iter = 2000, seed = list(123),
  return_fit = TRUE, mc.cores = 1, quiet = FALSE
)
print(fit.blind)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET model fitting: \code{\link{fit_censor}}, \code{\link{fit_enroll}},
\code{\link{fit_event_blind}}, \code{\link{fit_models}}, \cr \code{\link{fit_event_unblind}}
}
