% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beesChecklist.R
\name{beesChecklist}
\alias{beesChecklist}
\title{Download a country-level checklist of bees from Discover Life}
\usage{
beesChecklist(
  URL = "https://api.figshare.com/v2/file/download/60945823",
  mode = NULL,
  headers = NULL,
  token = NULL,
  alternateURL = FALSE,
  ...
)
}
\arguments{
\item{URL}{A character vector to the FigShare location of the dataset. The default will be to
the most-recent version.}

\item{mode}{A character passed on to \code{utils::download.file()}. Default = "wb" for Windows or "w" for Mac/Linux.}

\item{headers}{Character. Passed on to  \code{utils::download.file()}. Default = NULL.}

\item{token}{Character. Optional personal access token from FigShare account for authorisation.
Default = NULL.}

\item{alternateURL}{Logical. If TRUE then the function will use the an alernate version of the
download URL. Might be worth trying if it is failing. Default = FALSE.}

\item{...}{Extra variables that can be passed to \code{downloader::download()}.}
}
\value{
A downloaded beesChecklist.Rda file in the outPath and the same tibble returned to
the environment.

**Column details **

\strong{validName} The valid scientificName as it should occur in the scientificName column.

\strong{DiscoverLife_name} The full country name as it occurs on Discover Life.

\strong{rNaturalEarth_name} Country name from rnaturalearth's name_long.

\strong{shortName} A short version of the country name.

\strong{DiscoverLife_ISO} The ISO country name as it occurs on Discover Life.

\strong{Alpha-2} Alpha-2 from rnaturalearth.

\strong{Alpha-3} Alpha-3 from rnaturalearth.

\strong{official} Official country name = "yes" or only a Discover Life name = "no".

\strong{Source} A text strign denoting the source or author of the name-country pair.

\strong{matchCertainty} Quality of the name's match to the Discover Life checklist.

\strong{canonical} The valid species name without scientificNameAuthority.

\strong{canonical_withFlags} The validName without the scientificNameAuthority but with Discover Life flags.

\strong{family} Bee family.

\strong{subfamily} Bee subfamily.

\strong{genus} Bee genus.

\strong{subgenus} Bee subgenus.

\strong{infraspecies} Bee infraSpecificEpithet.

\strong{species} Bee specificEpithet.

\strong{scientificNameAuthorship} Bee scientificNameAuthorship.

\strong{taxon_rank} Rank of the taxon name.

\strong{Notes} Discover Life country name notes.

\strong{Previous checklists:}
\itemize{
\item 2026-01-12 \strong{current}: https://open.flinders.edu.au/ndownloader/files/60945823
\item 2024-06-17: https://open.flinders.edu.au/ndownloader/files/47092720
\item Original: https://open.flinders.edu.au/ndownloader/files/42320598
}
}
\description{
Download the table contains taxonomic and country information for the bees of the world based
on data collated on Discover Life. The data will be sourced from the BeeBDC article's
Figshare.

Note that sometimes the download might not work without restarting R. In this case, you could
alternatively download the dataset from the URL below and then read it in using
\code{base::readRDS("filePath.Rda")}. Note that as of version 1.3.2, this function internally uses
a modified version of the "download" function from the
\code{downloader} package on CRAN. Additionally, BeeBDC will try a different
download method with each failed attempt (for Windows: "auto" > "internal" > "libcurl" > "wget" > "curl";
or "auto" if any particular method is not available).

See \code{\link[=beesTaxonomy]{beesTaxonomy()}} for further context.
}
\examples{
\dontrun{
beesChecklist <- BeeBDC::beesChecklist()
}
}
\references{
This dataset was created using the Discover Life checklist and taxonomy.
Dataset is from the publication:
DOREY, J. B., CHESSHIRE, P. R., BOLAÑOS, A. N., O’REILLY, R. L., BOSSERT, S., COLLINS, S. M., LICHTENBERG, E. M., TUCKER, E., SMITH-PARDO, A., FALCON-BRINDIS, A., GUEVARA, D. A., RIBEIRO, B. R., DE PEDRO, D., FISCHER, E., HUNG, J. K.-L., PARYS, K. A., ROGAN, M. S., MINCKLEY, R. L., VELZCO, S. J. E., GRISWOLD, T., ZARRILLO, T. A., SICA, Y., ORR, M. C., GUZMAN, L. M., ASCHER, J., HUGHES, A. C. & COBB, N. S. In review. A globally synthesised and flagged bee occurrence dataset and cleaning workflow. Scientific Data.
The checklist data are mostly compiled from Discover Life data, www.discoverlife.org:
ASCHER, J. S. & PICKERING, J. 2020. Discover Life bee species guide and world checklist (Hymenoptera: Apoidea: Anthophila). http://www.discoverlife.org/mp/20q?guide=Apoidea_species.
}
