% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_main.R
\name{runSpecGraph}
\alias{runSpecGraph}
\title{Build spectral graph for SGWT object}
\usage{
runSpecGraph(
  SG,
  k = 25,
  laplacian_type = "normalized",
  length_eigenvalue = NULL,
  verbose = TRUE
)
}
\arguments{
\item{SG}{SGWT object from initSGWT()}

\item{k}{Number of nearest neighbors for graph construction (default: 25)}

\item{laplacian_type}{Type of graph Laplacian ("unnormalized", "normalized", or "randomwalk") (default: "normalized")}

\item{length_eigenvalue}{Number of eigenvalues/eigenvectors to compute (default: NULL, uses full length)}

\item{verbose}{Whether to print progress messages (default: TRUE)}
}
\value{
Updated SGWT object with Graph slot populated
}
\description{
Generate Graph slot information including adjacency matrix, 
Laplacian matrix, eigenvalues, and eigenvectors.
}
\examples{
\donttest{
# Create example data
data <- data.frame(x = runif(100), y = runif(100), signal = rnorm(100))
SG <- initSGWT(data, signals = "signal")

# Uses full length by default
SG <- runSpecGraph(SG, k = 30, laplacian_type = "normalized")  

# Or specify custom length
SG2 <- initSGWT(data, signals = "signal")
SG2 <- runSpecGraph(SG2, k = 30, laplacian_type = "normalized", 
                    length_eigenvalue = 30)  
}
}
