% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuddleMain.R
\name{FetchBuddle}
\alias{FetchBuddle}
\title{Predicting Classification and Regression.}
\usage{
FetchBuddle(X, lW, lb, lParam)
}
\arguments{
\item{X}{a matrix of real values which will be used for predicting classification or regression.}

\item{lW}{a list of weight matrices obtained after training.}

\item{lb}{a list of bias vectors obtained after training.}

\item{lParam}{a list of parameters used for training. It includes: label, hiddenlayer, batch, drop, drop.ratio, lr, init.weight, activation, optim, type, rand.eff, distr, and disp.}
}
\value{
A list of the following values: 
\describe{
\item{predicted}{predicted real values (regression) or softmax values (classification).}

\item{One.Hot.Encoding}{one-hot encoding values of the predicted softmax values for classification. For regression, a zero matrix will be returned. To convert the one-hot encoding values to labels, use OneHot2Label().}
}
}
\description{
Yield prediction (softmax value or value) for regression and classification for given data based on the results of training.
}
\examples{

### Using mnist data again

data(mnist_data)

X1 = mnist_data$Images       ### X1: 100 x 784 matrix
Y1 = mnist_data$Labels       ### Y1: 100 x 1 vector



############################# Train Buddle

lst = TrainBuddle(Y1, X1, train.ratio=0.6, arrange=TRUE, batch.size=10, total.iter = 100, 
                 hiddenlayer=c(20, 10), batch.norm=TRUE, drop=TRUE, 
                 drop.ratio=0.1, lr=0.1, init.weight=0.1, 
                 activation=c("Relu","SoftPlus"), optim="AdaGrad", 
                 type = "Classification", rand.eff=TRUE, distr = "Logistic", disp=TRUE)

lW = lst[[1]]
lb = lst[[2]]
lParam = lst[[3]]


X2 = matrix(rnorm(20*784,0,1), 20,784)  ## Genderate a 20-by-784 matrix

lst = FetchBuddle(X2, lW, lb, lParam)   ## Pass X2 to FetchBuddle for prediction





}
\references{
[1] Geron, A. Hand-On Machine Learning with Scikit-Learn and TensorFlow. Sebastopol: O'Reilly, 2017. Print.

[2] Han, J., Pei, J, Kamber, M. Data Mining: Concepts and Techniques. New York: Elsevier, 2011. Print.

[3] Weilman, S. Deep Learning from Scratch. O'Reilly Media, 2019. Print.
}
\seealso{
CheckNonNumeric(), GetPrecision(), MakeConfusionMatrix(), OneHot2Label(), Split2TrainTest(), TrainBuddle()
}
