% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homophilidata.R
\name{homophili.data}
\alias{homophili.data}
\title{Converting Data between Directed Network Models and Symmetric Network Models.}
\usage{
homophili.data(data, nvec, to = c("lower", "upper", "symmetric"))
}
\arguments{
\item{data}{A \code{matrix} or \code{data.frame} of the explanatory variables of the network formation model. This
corresponds to the \code{X} matrix in \code{\link{homophily.fe}} or \code{\link{homophily.re}}.}

\item{nvec}{A vector of the number of individuals in the networks.}

\item{to}{Indicates the direction of the conversion. For a matrix of explanatory variables \code{X} (\code{n*(n-1)} rows), one can
select lower triangular entries (\code{to = "lower"}) or upper triangular entries (\code{to = "upper"}).
For a triangular \code{X} (\code{n*(n-1)/2} rows), one can convert to a full matrix of \code{n*(n-1)} rows by using symmetry (\code{to = "symmetric"}).}
}
\value{
The transformed \code{data.frame}.
}
\description{
\code{homophili.data} converts the matrix of explanatory variables between directed network models and symmetric network models.
}
