% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxfunc.R
\name{remove.ids}
\alias{remove.ids}
\title{Removing Identifiers with NA from Adjacency Matrices Optimally}
\usage{
remove.ids(network, ncores = 1L)
}
\arguments{
\item{network}{A list of adjacency matrices to process.}

\item{ncores}{The number of cores to use for parallel computation.}
}
\value{
A list containing:
\describe{
\item{network}{A list of adjacency matrices without missing values.}
\item{id}{A list of vectors indicating the indices of retained rows and columns for each matrix.}
}
}
\description{
The \code{remove.ids} function removes identifiers with missing values (NA) from adjacency matrices in an optimal way.
Multiple combinations of rows and columns can be deleted to eliminate NAs, but this function ensures that the smallest
number of rows and columns are removed to retain as much data as possible.
}
\examples{
# Example 1: Small adjacency matrix
A <- matrix(1:25, 5)
A[1, 1] <- NA
A[4, 2] <- NA
remove.ids(A)

# Example 2: Larger adjacency matrix with multiple NAs
B <- matrix(1:100, 10)
B[1, 1] <- NA
B[4, 2] <- NA
B[2, 4] <- NA
B[, 8] <- NA
remove.ids(B)
}
