% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariable.models.R
\name{univariable.models}
\alias{univariable.models}
\title{Univariable Logistic Regression Summary Table}
\usage{
univariable.models(
  data,
  yval,
  xval,
  OR = FALSE,
  inc.or = NULL,
  confidence.level = 0.95
)
}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{yval}{A string indicating the name of the binary outcome variable.}

\item{xval}{A character vector with the names of the explanatory variables to be evaluated univariately.}

\item{OR}{Logical; if TRUE, odds ratios and their confidence intervals are returned. Default to FALSE.}

\item{inc.or}{A numeric vector of scaling factors to be applied to each coefficient to obtain odds ratios.}

\item{confidence.level}{The confidence level to use for interval estimation of odds ratios. Defaults to 0.95.}
}
\value{
A data frame with coefficients from the univariable models, standard errors, p-values, and, if requested, odds ratios with lower and upper confidence limits.
}
\description{
Fits univariable logistic regression models \code{glm} function for a set of predictors and summarizes coefficients,
standard errors, likelihood ratio test statistics, and optionally odds ratios with confidence intervals.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 4, Table 4.7

# Define variables to evaluate
unvariables <- c(
  'age','weight','height', 'bmi', 'priorfrac', 'premeno', 'momfrac',
  'armassist','smoke', 'raterisk')

# Define value ranges used to interpret odds ratios (Optional)
val.pe <- c(5, 5, 10, 5, 1, 1, 1, 1, 1, 1, 1)

# Run univariable conditional logistic regressions
univariable.models(glow500, yval = 'fracture', xval = unvariables, OR = TRUE, inc.or = val.pe)

}
