% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QH.R
\name{QH}
\alias{QH}
\title{QH: Quesenberry and Hurst Method for Simultaneous Confidence Intervals}
\usage{
QH(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed cell counts corresponding to
a categorical dataset. Must contain non-negative values.}

\item{alpha}{Desired statistical significance level}
}
\value{
Prints the original and adjusted confidence intervals for each
category, as well as the overall volume of the simultaneous confidence
intervals.
}
\description{
Computes simultaneous confidence intervals for multinomial proportions
using the Quesenberry and Hurst (1964) method. The function calculates
lower and upper confidence limits for each category, adjusts them to remain
within the valid [0, 1] range, and computes the overall interval volume
(the product of the interval widths).
}
\details{
This function implements the simultaneous confidence interval method
proposed by Quesenberry and Hurst (1964) for multinomial proportions.
It adjusts each interval to ensure limits remain within the [0, 1] range.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
QH(y, z)

}
\references{
Quesenberry, C. P., and Hurst, D. C. (1964).
*Large Sample Simultaneous Confidence Intervals for Multinomial Proportions.*
Technometrics, **6**, 191–195.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALD}}, \code{\link{WS}}
}
\author{
Dr. M. Subbiah
}
