% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{LikelihoodBound.coxres}
\alias{LikelihoodBound.coxres}
\title{Calculates the likelihood boundary for a completed cox model}
\usage{
\method{LikelihoodBound}{coxres}(x, df, curve_control = list(), control = list(), ...)
}
\arguments{
\item{x}{result object from a regression, class coxres}

\item{df}{a data.table containing the columns of interest}

\item{curve_control}{a list of control options for the likelihood boundary regression. See the Control_Options vignette for details.}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{...}{can include the named entries for the curve_control list parameter}
}
\value{
returns a list of the final results
}
\description{
\code{LikelihoodBound.coxres} solves the confidence interval for a cox model, starting at the optimum point and
iteratively optimizing end-points of intervals.
}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{CoxRun}()},
\code{\link{CoxRunMulti}()}
}
\concept{Cox Wrapper Functions}
