% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_download_subset.r
\name{cms_zarr_proxy}
\alias{cms_zarr_proxy}
\title{Get a proxy stars object from a Zarr service}
\usage{
cms_zarr_proxy(
  product,
  layer,
  variable,
  asset,
  ...,
  username = cms_get_username(),
  password = cms_get_password()
)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_services}} (listed as \code{id} column).}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{cms_product_details}}.}

\item{asset}{An asset that is available for the \code{product}.
Should be one of \code{"native"}, \code{"wmts"}, \code{"timeChunked"}, \code{"downsampled4"},
or \code{"geoChunked"}.}

\item{...}{Ignored (reserved for future features).}

\item{username}{Your Copernicus marine user name. Can be provided with
\code{cms_get_username()} (default), or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{cms_get_password()} (default), or as argument here.}
}
\value{
A \href{https://r-spatial.github.io/stars/articles/stars2.html#stars-proxy-objects}{\code{stars_proxy} object}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The advantage of
\href{https://r-spatial.github.io/stars/articles/stars2.html#stars-proxy-objects}{\code{stars_proxy} objects},
is that they do not contain any data. They are therefore fast to handle
and consume only limited memory. You can still manipulate the object
lazily (like selecting slices). These operation are only executed when
calling \code{\link[stars:st_as_stars]{stars::st_as_stars()}} or \code{plot()} on the object.
}
\details{
For more details see \code{vignette("proxy")}.
}
\examples{
if (interactive()) {
  myproxy <- cms_zarr_proxy(
    product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer         = "cmems_mod_glo_phy-cur_anfc_0.083deg_P1D-m",
    variable      = c("uo", "vo"),
    asset         = "timeChunked")
  plot(myproxy["uo",1:200,1:100,50,1], axes = TRUE)
}
}
\author{
Pepijn de Vries
}
