% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_rf.R
\name{cyt_rf}
\alias{cyt_rf}
\title{Run Random Forest Classification on Cytokine Data,}
\usage{
cyt_rf(
  data,
  group_col,
  ntree = 500,
  mtry = 5,
  train_fraction = 0.7,
  plot_roc = FALSE,
  k_folds = 5,
  step = 0.5,
  run_rfcv = TRUE,
  verbose = FALSE,
  seed = 123,
  cv = FALSE,
  cv_folds = 5,
  scale = c("none", "log2", "log10", "zscore", "custom"),
  custom_fn = NULL
)
}
\arguments{
\item{data}{A data frame containing the cytokine measurements.  One column
should correspond to the grouping variable (the outcome) and the
remaining columns should be numeric predictors.}

\item{group_col}{A string naming the column in \code{data} that contains the
grouping variable.}

\item{ntree}{Integer specifying the number of trees to grow.  Default is
500.}

\item{mtry}{Integer specifying the number of variables randomly sampled at
each split.  Default is 5.}

\item{train_fraction}{Numeric between 0 and 1 giving the proportion of data
used for training.  The remainder is used for testing.  Default is 0.7.}

\item{plot_roc}{Logical.  If \code{TRUE} and the problem is binary, an ROC curve
and AUC will be computed and plotted for the test set.  Default is
\code{FALSE}.}

\item{k_folds}{Integer specifying the number of folds for \code{rfcv} when
\code{run_rfcv = TRUE}.  Default is 5.}

\item{step}{Numeric specifying the fraction of variables removed at each
step during \code{rfcv}.  Default is 0.5.}

\item{run_rfcv}{Logical indicating whether to run Random Forest
cross-validation for feature selection.  Default is \code{TRUE}.}

\item{verbose}{Logical indicating whether to print intermediate results.
When \code{TRUE}, training and test performance metrics, confusion matrices
and cross-validation details are printed.  Default is \code{FALSE}.}

\item{seed}{Optional integer seed for reproducibility.  Default is 123.}

\item{cv}{Logical indicating whether to perform a separate k-fold
classification cross-validation using \code{caret}.  Default is \code{FALSE}.}

\item{cv_folds}{Integer specifying the number of folds for classification
cross-validation when \code{cv = TRUE}.  Default is 5.}

\item{scale}{Character string specifying a transformation to apply to the
numeric predictor columns prior to model fitting.  Options are
"none" (no transformation), "log2", "log10", "zscore", or
"custom".  When "custom" is selected a user defined function
must be supplied via \code{custom_fn}.  Defaults to "none".}

\item{custom_fn}{A custom transformation function used when \code{scale = "custom"}.
The function should take a numeric vector and return a numeric vector
of the same length.  Ignored for other values of \code{scale}.}
}
\value{
An invisible list with components:
\item{model}{The fitted \code{randomForest} model.}
\item{confusion_matrix}{Confusion matrix on the test set.}
\item{importance_plot}{A \code{ggplot2} object of the variable importance
(mean decrease in Gini).}
\item{importance_data}{A data frame of variable importance values.}
\item{rfcv_result}{The \code{rfcv} object returned when \code{run_rfcv = TRUE}.}
\item{rfcv_plot}{A \code{ggplot2} object of cross-validation error versus
number of variables, returned when \code{run_rfcv = TRUE}.}
\item{rfcv_data}{A data frame summarizing the \code{rfcv} error curve.}
\item{roc_plot}{A \code{ggplot2} object of the ROC curve for binary
classification when \code{plot_roc = TRUE}.}
\item{cv_results}{A \code{caret} train object returned when \code{cv = TRUE} or
\code{NULL} otherwise.}
}
\description{
This function trains and evaluates a Random Forest classification model on
cytokine data. It includes feature importance visualization, cross-
validation for feature selection, and performance metrics such as accuracy,
sensitivity, and specificity. Optionally, for binary classification, the
function also plots the ROC curve and computes the AUC.
}
\details{
The function first coerces the grouping variable to a factor and splits
the dataset into training and test subsets according to
\code{train_fraction}.  A Random Forest classifier is fit to the training
data using the specified \code{ntree} and \code{mtry} parameters.  The model
performance is assessed on both the training and test sets, and
results are printed when \code{verbose = TRUE}.  If \code{plot_roc = TRUE} and
the grouping variable has exactly two levels, an ROC curve is computed
on the test set and a plot is returned.  Variable importance is
extracted and visualized with a bar plot.  Optionally, cross-
validation for feature selection (\code{rfcv}) is performed and the error
curve is plotted.  A separate k-fold classification cross-
validation using \code{caret::train} can be requested via \code{cv = TRUE}.
}
\examples{
data.df0 <- ExampleData1
data.df <- data.frame(data.df0[, 1:3], log2(data.df0[, -c(1:3)]))
data.df <- data.df[, -c(2:3)]
data.df <- dplyr::filter(data.df, Group != "ND")

cyt_rf(
  data = data.df, group_col = "Group", k_folds = 5, ntree = 1000,
  mtry = 4, run_rfcv = TRUE, plot_roc = TRUE, verbose = FALSE
)
}
