% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{ItargetE1}
\alias{ItargetE1}
\alias{ItargetE2}
\alias{ItargetE3}
\alias{ItargetE4}
\title{Incremental Index Target MP - Effort-Based}
\usage{
ItargetE1(x, Data, reps = 100, plot = FALSE, yrsmth = 5, Imulti = 1.5)

ItargetE2(x, Data, reps = 100, plot = FALSE, yrsmth = 5, Imulti = 2)

ItargetE3(x, Data, reps = 100, plot = FALSE, yrsmth = 5, Imulti = 2.5)

ItargetE4(x, Data, reps = 100, plot = FALSE, yrsmth = 5, Imulti = 2.5)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which the average index is calculated.}

\item{Imulti}{Parameter controlling how much larger target CPUE / index is
compared with recent levels.}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the TAE slot(s) populated
}
\description{
A management procedure that incrementally adjusts the fishing effort
to reach a target CPUE / relative abundance index
}
\details{
Four index/CPUE target MPs proposed by Geromont and Butterworth 2014.

The TAE is calculated as:
If  \eqn{I_\textrm{recent} \geq I_0}:
\deqn{\textrm{TAE}_y = 0.5 \textrm{TAE}_{y-1}  \left[1+ \left( \frac{I_{\textrm{recent}} - I_0}{I_{\textrm{target}} - I_0} \right)\right]}

else:
\deqn{\textrm{TAE}_y= 0.5 \textrm{TAE}_{y-1} \left( \frac{I_{\textrm{recent}}}{I_0}^2 \right)}

where \eqn{I_0} is \eqn{0.8 I_{\textrm{ave}}} (the average index over the 2 x \code{yrsmth} years prior to the projection period),
\eqn{I_\textrm{recent}} is the average index over the past \code{yrsmth} years, and
\eqn{I_\textrm{target}} is \code{Imulti} times \eqn{I_{\textrm{ave}}}.
}
\section{Functions}{
\itemize{
\item \code{ItargetE1()}: The less precautionary TAE-based MP

\item \code{ItargetE2()}: Increasing biologically precautionary TAE-based MP

\item \code{ItargetE3()}: Increasing biologically precautionary TAE-based MP

\item \code{ItargetE4()}: The most biologically precautionary TAE-based MP

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{ItargetE1}: Ind, LHYear, MPeff, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/ItargetE1.html}{Online Documentation} for correctly rendered equations
}

\examples{
ItargetE1(1, MSEtool::Atlantic_mackerel, plot=TRUE)
ItargetE2(1, MSEtool::Atlantic_mackerel, plot=TRUE)
ItargetE3(1, MSEtool::Atlantic_mackerel, plot=TRUE)
ItargetE4(1, MSEtool::Atlantic_mackerel, plot=TRUE)
}
\references{
Carruthers et al. 2015. Performance evaluation of simple
management procedures. ICES J. Mar Sci. 73, 464-482.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci. 72, 251-261.
doi:10.1093/icesjms/fst232
}
\seealso{
Other Index methods: 
\code{\link{GB_slope}()},
\code{\link{GB_target}()},
\code{\link{Gcontrol}()},
\code{\link{ICI}()},
\code{\link{Iratio}()},
\code{\link{Islope1}()},
\code{\link{Itarget1}()},
\code{\link{Itarget1_MPA}()}
}
\author{
T. Carruthers
}
\concept{Index methods}
