% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsSession}
\alias{dsSession}
\title{Create a remote R session}
\usage{
dsSession(conn, async = TRUE)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) 
the calls are parallelized over the connections, when the connection supports 
that feature, with an extra overhead of requests.}
}
\value{
An object of class \code{\link{DSSession-class}} representing the remote R session.
}
\description{
Create a remote R session if none exists. If a remote R session already exists,
it will be reused. Returns a logical indicating if a remote R session exists
accessible through this connection.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsSession(con, async=TRUE)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasSession}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
