% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsSession,OpalConnection-method}
\alias{dsSession,OpalConnection-method}
\title{Create a remote R session}
\usage{
\S4method{dsSession}{OpalConnection}(conn, async = TRUE)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{OpalConnection-class}}.}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default)
the calls are parallelized over the connections, when the connection supports
that feature, with an extra overhead of requests.}
}
\value{
An object of class \code{\link{OpalSession-class}} representing the remote R session.
}
\description{
Create a remote R session if none exists. If a remote R session already exists,
it will be reused. Returns an object of class \code{\link{OpalSession-class}} representing
the remote R session accessible through this connection.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
session <- dsSession(con, async=TRUE)
dsDisconnect(con)
}
}
