% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gdm.R
\name{export_simulated_gdm}
\alias{export_simulated_gdm}
\title{Export a simulated GDM to CSV}
\usage{
export_simulated_gdm(
  output_file = tempfile("gdm_", fileext = ".csv"),
  scenario = "default",
  n_pops = 30,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{output_file}{Output CSV filename (defaults to a session-scoped temporary path)}

\item{scenario}{Scenario name}

\item{n_pops}{Number of populations}

\item{verbose}{Verbose output}

\item{seed}{Optional seed forwarded to run_genetic_scenario()}
}
\value{
Invisibly, the normalized path to the written CSV
}
\description{
Export a simulated GDM to CSV
}
\examples{
tmp <- export_simulated_gdm(verbose = FALSE)
if (file.exists(tmp)) unlink(tmp)
}
