% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_neural.R
\name{pattc_neural}
\alias{pattc_neural}
\title{Estimate PATT_C using Deep NN}
\usage{
pattc_neural(
  response.formula,
  exp.data,
  pop.data,
  treat.var,
  compl.var,
  compl.algorithm = "rprop+",
  response.algorithm = "rprop+",
  compl.hidden.layer = c(4, 2),
  response.hidden.layer = c(4, 2),
  compl.act.fct = "logistic",
  response.err.fct = "sse",
  response.act.fct = "logistic",
  linear.output = TRUE,
  compl.stepmax = 1e+08,
  response.stepmax = 1e+08,
  ID = NULL,
  cluster = NULL,
  binary.preds = FALSE,
  bootstrap = FALSE,
  nboot = 1000
)
}
\arguments{
\item{response.formula}{formula of response variable as outcome and
covariates (y ~ x)}

\item{exp.data}{\code{data.frame} of experimental data. Must include binary
treatment and compliance variables.}

\item{pop.data}{\code{data.frame} of population data. Must include binary
compliance variable}

\item{treat.var}{string for treatment variable.}

\item{compl.var}{string for compliance variable}

\item{compl.algorithm}{string for algorithm to train neural network for
compliance model. Default set to \code{"rprop+"}. See (\code{neuralnet} package for
available algorithms).}

\item{response.algorithm}{string for algorithm to train neural network for
response model. Default set to \code{"rprop+"}. See (\code{neuralnet} package for
available algorithms).}

\item{compl.hidden.layer}{vector for specifying hidden layers and number of
neurons in complier model.}

\item{response.hidden.layer}{vector for specifying hidden layers and number of
neurons in response model.}

\item{compl.act.fct}{"logistic" or "tanh" activation function for complier model.}

\item{response.err.fct}{"sse" for sum of squared errors or "ce" for cross-entropy for response model.}

\item{response.act.fct}{"logistic" or "tanh" activation function for response model.}

\item{linear.output}{logical for whether output (outcome variable) is linear or not for response model.}

\item{compl.stepmax}{maximum number of steps for complier model}

\item{response.stepmax}{maximum number of steps for response model}

\item{ID}{string for identifier variable}

\item{cluster}{string for cluster variable.}

\item{binary.preds}{logical specifying predicted outcome variable will take
binary values or proportions.}

\item{bootstrap}{logical for bootstrapped PATT-C.}

\item{nboot}{number of bootstrapped samples}
}
\value{
\code{pattc_neural} class object of results of t test as PATTC estimate.
}
\description{
estimates the Population Average Treatment Effect
of the Treated from experimental data with noncompliers using Deep Neural
Networks.
}
\examples{
# load datasets
data(exp_data) #experimental data
data(pop_data) #population data
# specify models and estimate PATTC
set.seed(123456)

pattc_neural_boot <- pattc_neural(response.formula = support_war ~ age + female +
                               income + education +  employed + married +
                               hindu + job_loss,
                               exp.data = exp_data,
                               pop.data = pop_data,
                               treat.var = "strong_leader",
                               compl.var = "compliance",
                               compl.algorithm = "rprop+",
                               response.algorithm = "rprop+",
                               compl.hidden.layer = c(2),
                               response.hidden.layer = c(2),
                               compl.stepmax = 1e+09,
                               response.stepmax = 1e+09,
                               ID = NULL,
                               cluster = NULL,
                               binary.preds = FALSE,
                               bootstrap = TRUE,
                               nboot = 1000)

}
