% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{compute_drug_response_scores}
\alias{compute_drug_response_scores}
\title{Calculate drug response score}
\usage{
compute_drug_response_scores(differential_graph, drug_targets, settings)
}
\arguments{
\item{differential_graph}{iGraph graph object containing differential scores for all edges.
(output of \code{\link[DrDimont]{generate_differential_score_graph}})}

\item{drug_targets}{[list] Named list containing two elements (`target_nodes` and
`drugs_to_target_nodes`). `targets` from output of \code{\link[DrDimont]{determine_drug_targets}}. `target_nodes` is a
vector containing network node names of the nodes that are targeted by the available drugs.
`drugs_to_target_nodes` is a dictionary-like list that maps drugs to the nodes that they
target.}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
Dataframe containing drug name and associated differential (integrated) drug response score
}
\description{
This function takes the differential graph (generated in
\code{\link[DrDimont]{generate_differential_score_graph}}), the a drug targets object (containing target node names and
drugs and their targets; generated in \code{\link[DrDimont]{determine_drug_targets}}) and the supplied
drug-target interaction table (formatted in \code{\link[DrDimont]{make_drug_target}}) to calculate the
differential drug response score. The score is the mean or median of all differential scores of the
edges adjacent to all drug target nodes of a particular drug.
}
\examples{
data(drug_target_edges_example)
data(differential_graph_example)

example_settings <- drdimont_settings()

example_drug_response_scores <- compute_drug_response_scores(
                                    differential_graph=differential_graph_example,
                                    drug_targets=drug_target_edges_example$targets,
                                    settings=example_settings)

}
