% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{mrna_data}
\alias{mrna_data}
\title{mRNA expression data}
\format{
\describe{
  \item{groupA}{ER+ data; data.frame: first column contains mRNA/gene identifier gene_name;
                other columns are samples containing the quantified mRNA data per gene}
  \item{groupB}{ER- data; data.frame: first column contains mRNA/gene identifier gene_name;
                other columns are samples containing the quantified mRNA data per gene}
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
 Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
mrna_data
}
\description{
mRNA analysis of breast cancer patient data from Krug et al. (2020) (data from the Clinical
Proteomic Tumor Analysis Consortium (CPTAC)). The data is stratified by estrogen receptor (ER)
expression status (`groupA` = ER+, `groupB` = ER-). The data was reduced to 50 genes.
For each group, a dataframe is given containing the raw data with the mRNA/gene as rows and the
samples as columns. The first column contains the gene identifiers (gene_name).
}
\keyword{datasets}
