% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metadata_format.R
\name{read_metadata_format}
\alias{read_metadata_format}
\title{Read metadata format}
\usage{
read_metadata_format(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) Metadata format type
}
\description{
Read metadata format
}
\examples{
\dontrun{

# Read format
metadataFormat <- read_metadata_format("knb-lter-nwt.930.1")
metadataFormat
#> [1] "eml://ecoinformatics.org/eml-2.1.1"
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
