% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{run_hyper}
\alias{run_hyper}
\title{Run a Group-level Model.}
\usage{
run_hyper(
  type = "standard",
  data,
  prior = NULL,
  iter = 1000,
  n_chains = 3,
  ...
)
}
\arguments{
\item{type}{A string indicating whether to run a \code{standard} group-level, \code{blocked}, \code{diagonal}, \code{factor}, or \code{single} (i.e., non-hierarchical) model.}

\item{data}{A data frame, or a list of data frames. Needs to have the variable \code{subjects} as participant identifier.}

\item{prior}{an emc.prior object.}

\item{iter}{Number of MCMC samples to collect.}

\item{n_chains}{An integer. Specifies the number of mcmc chains to be run (has to be more than 1 to compute \code{rhat}).}

\item{...}{Additional, optional arguments.}
}
\value{
an emc object with only group-level samples
}
\description{
Separate function for running only the group-level model. This can be useful in a
two-step analysis. Works similar in functionality to make_emc,
except also does the fitting and returns an emc object that works with
most posterior checking tests (but not the data generation/posterior predictives).
}
