test_that("non-significant comparison works", {
  x <- seq(-1, 1, length = 200)
  a <- rep(c("a", "b"), 100)
  DF <- data.frame(numVar = x, setVar = a)
  indexA <- which(DF$setVar == "a")
  WelchVector <- WelchRankTest(DF, "numVar", indexA)
  expect_equal(as.numeric(WelchVector["nA"]), 100)
  expect_equal(as.numeric(WelchVector["nB"]), 100)
  expect_equal(round(as.numeric(WelchVector["medianA"]), digits = 5),
               round(median(x[indexA]), digits = 5))
  expect_equal(round(as.numeric(WelchVector["medianB"]), digits = 5),
               round(median(x[-indexA]), digits = 5))
  z <- c(x[indexA], x[-indexA])
  zRanks <- rank(z)
  xRanks <- zRanks[1:100]
  yRanks <- zRanks[101:200]
  testObj <- stats::t.test(xRanks, yRanks, conf.level = 0.95)
  expect_equal(round(as.numeric(WelchVector["pValue"]), digits = 5),
               round(testObj$p.value, digits = 5))
})
test_that("significant comparison works", {
  x <- seq(-1, 1, length = 200)
  a <- rep(c("a", "b"), 100)
  DF <- data.frame(numVar = x, setVar = a)
  indexA <- which(DF$setVar == "a")
  offset <- rep(0, length(x))
  offset[indexA] <- 0.2
  xMod <- x + offset
  DF$numVar2 <- xMod
  WelchVector <- WelchRankTest(DF, "numVar2", indexA)
  expect_equal(as.numeric(WelchVector["nA"]), 100)
  expect_equal(as.numeric(WelchVector["nB"]), 100)
  expect_equal(round(as.numeric(WelchVector["medianA"]), digits = 5),
               round(median(xMod[indexA]), digits = 5))
  expect_equal(round(as.numeric(WelchVector["medianB"]), digits = 5),
               round(median(xMod[-indexA]), digits = 5))
  z <- c(xMod[indexA], xMod[-indexA])
  zRanks <- rank(z)
  xRanks <- zRanks[1:100]
  yRanks <- zRanks[101:200]
  testObj <- stats::t.test(xRanks, yRanks, conf.level = 0.95)
  expect_equal(round(as.numeric(WelchVector["pValue"]), digits = 5),
               round(testObj$p.value, digits = 5))
})
