% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mldfm_subsampling.R
\name{mldfm_subsampling}
\alias{mldfm_subsampling}
\title{Subsampling Procedure for MLDFM Estimation}
\usage{
mldfm_subsampling(
  data,
  blocks = 1,
  block_ind = NULL,
  global = 1,
  local = NULL,
  middle_layer = NULL,
  method = 0,
  tol = 1e-06,
  max_iter = 1000,
  center = TRUE,
  scale = TRUE,
  n_samples = 10,
  sample_size = 0.9,
  seed = NULL
)
}
\arguments{
\item{data}{A numeric matrix or data frame containing the time series data. Rows represent time points; columns represent observed variables.}

\item{blocks}{Integer. The number of blocks into which the data is divided.}

\item{block_ind}{A vector of integers indicating the end index of each block. Must be of length \code{blocks} and in increasing order. Required if \code{blocks > 1}.}

\item{global}{Integer. Number of global factors extracted from the entire dataset.}

\item{local}{Integer vector of length \code{blocks}. Specifies the number of local factors for each block.}

\item{middle_layer}{Named list. Each name is a string specifying a group of blocks (e.g., \code{"1-3"} or \code{"2-3"}), and each value is the number of factors to extract.}

\item{method}{Integer. The method used to initialize the factors: \code{0} for Canonical Correlation Analysis (CCA), \code{1} for Principal Component Analysis (PCA).}

\item{tol}{Numeric. The tolerance level for the residual sum of squares (RSS) minimization process. Used as a convergence criterion.}

\item{max_iter}{Integer. The maximum number of iterations allowed for the RSS minimization process.}

\item{center}{Logical. If \code{TRUE} (default) center data columns.}

\item{scale}{Logical. If \code{TRUE} (default) scale data columns.}

\item{n_samples}{Number of subsamples to generate.}

\item{sample_size}{Proportion of the original sample to retain (e.g., 0.9 for 90\%).}

\item{seed}{Optional integer. Seed for reproducibility of the subsampling process. If \code{NULL}, random draws will differ each run.}
}
\value{
An object of class \code{mldfm_subsample}, which is a list containing:
\itemize{
\item \code{models}: A list of \code{mldfm} objects, one for each subsample.
\item \code{n_samples}: Number of subsamples generated.
\item \code{sample_size}: Proportion of the sample used for each subsample.
\item \code{seed}: Seed used for random sampling (if any).
\item \code{call}: Function call.
}
}
\description{
Applies the MLDFM estimation to randomly drawn subsamples of the input data.
}
\examples{
\donttest{
data <- matrix(rnorm(1000), nrow = 100, ncol = 100)
block_ind <- c(50,100)  
local <- c(1, 1)   
result <- mldfm_subsampling(data, blocks = 2, block_ind = block_ind, global = 1, 
local = local, n_samples = 100, sample_size = 0.9)
}

}
