% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{get_Sigs}
\alias{get_Sigs}
\title{Compute the covariance matrix \eqn{\Sigma_{\mathrm{ALL}}^*} for observations within a moving window}
\usage{
get_Sigs(w, p, Sig_eta, Sig_nu, Phi, Sig_e1)
}
\arguments{
\item{w}{Integer; window size.}

\item{p}{Integer; data dimension.}

\item{Sig_eta}{Numeric \eqn{p \times p} matrix representing the covariance
of the random walk innovation \eqn{\Sigma_{\boldsymbol{\eta}}}.}

\item{Sig_nu}{Numeric \eqn{p \times p} matrix representing the covariance
of the VAR(1) innovation \eqn{\Sigma_{\boldsymbol{\nu}}}.}

\item{Phi}{Numeric \eqn{p \times p} autoregressive coefficient matrix
\eqn{\Phi}.}

\item{Sig_e1}{Numeric \eqn{p \times p} matrix representing the covariance
of the initial state \eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}.}
}
\value{
A list with the following components:
\itemize{
  \item `Sig_AR` — Covariance contribution from the VAR(1) component
    (\eqn{\Sigma_{\mathrm{AR}}}).
  \item `Sig_RW` — Covariance contribution from the random walk component
    (\eqn{\Sigma_{\mathrm{RW}}}).
  \item `Sig_all` — Combined covariance matrix
    (\eqn{\Sigma_{\mathrm{ALL}}^* = \Sigma_{\mathrm{AR}} + \Sigma_{\mathrm{RW}}}).
  \item `Sig_all_inv` — Inverse of the combined covariance matrix
    \eqn{(\Sigma_{\mathrm{ALL}}^*)^{-1}}.
}
}
\description{
Calculates the covariance matrix \eqn{\Sigma_{\mathrm{ALL}}^*} for all
observations within a moving window of length \eqn{w}, given the random walk
innovation covariance \eqn{\Sigma_{\boldsymbol{\eta}}}, the VAR(1) innovation
covariance \eqn{\Sigma_{\boldsymbol{\nu}}}, the autoregressive coefficient
matrix \eqn{\Phi}, and the initial-state covariance matrix
\eqn{\Gamma_{\boldsymbol{\epsilon}}(0)} (denoted here by `Sig_e1`).
The resulting matrix accounts for both the random walk component and
the temporal dependence introduced by the VAR(1) structure.
}
\details{
The function decomposes the overall covariance matrix
\eqn{\Sigma_{\mathrm{ALL}}^*} into two additive components corresponding to
the random walk contribution \eqn{\Sigma_{\mathrm{RW}}} and the
autoregressive contribution \eqn{\Sigma_{\mathrm{AR}}}, so that
\deqn{\Sigma_{\mathrm{ALL}}^* = \Sigma_{\mathrm{RW}} + \Sigma_{\mathrm{AR}}.}
When \eqn{p = 1}, the construction reduces to the scalar random walk and
AR(1) case, for which closed-form covariance expressions are available.
For higher-dimensional settings, block-matrix structures are constructed
using functions from the \pkg{blockmatrix} package to capture both
cross-sectional and temporal dependence. The returned inverse matrix
\eqn{(\Sigma_{\mathrm{ALL}}^*)^{-1}} is used in the main change point
detection algorithm to adjust for the effects of random walk drift and
vector autoregressive correlation.
}
\examples{
set.seed(1)
p <- 3
w <- 20
Sig_eta <- diag(0.01, p)
Sig_nu  <- random_Signu(p, 0)
Phi <- random_Phi(p, p)
Sig_e1 <- get_Sig_e1_approx(Sig_nu, Phi)
res <- get_Sigs(w, p, Sig_eta, Sig_nu, Phi, Sig_e1)

}
