% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c150_c130.R
\name{c150_c130}
\alias{c150_c130}
\title{Convert circumference between 1.50 m and 1.30 m}
\usage{
c150_c130(data, output = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing at least:
\itemize{
\item \code{species_code}: tree species code,
\item \code{c150}: stem circumference at 1.50 m (cm), or
\item \code{c130}: stem circumference at 1.30 m (cm).
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A \code{data.frame} identical to the input but augmented with:
\itemize{
\item species-specific coefficients and validity ranges,
\item both \code{c150} and \code{c130} columns completed whenever possible.
}
}
\description{
Computes stem circumference at 1.30 m (\code{c130}, in cm)
from circumference at 1.50 m (\code{c150}, in cm) using
species-specific linear coefficients stored in the reference table
\code{c150_c130_coeff}. If only \code{c130} is available, the function
back-computes \code{c150} using the inverse of the same equation.
}
\details{
The conversion equation is:
\deqn{
  c130 = a \cdot c150 + b
}
where \eqn{a} and \eqn{b} are species-specific coefficients.

The function performs the following steps:
\itemize{
\item checks that the input data frame contains the required
variables \code{species_code} and at least one of \code{c150} or \code{c130},
\item validates that numeric values are provided,
\item verifies that all species are available in the \code{c150_c130_coeff}
reference table and issues a warning otherwise,
\item merges the input with \code{c150_c130_coeff} to retrieve coefficients
and species-specific validity ranges (\code{min_c150}, \code{max_c150}),
\item warns when circumference values fall outside the recommended range,
\item computes missing \code{c130} from \code{c150}, or missing \code{c150} from \code{c130},
\item returns the augmented data frame with both columns completed.
}
}
\section{Supported species}{

The following species codes are supported by \code{c150_c130}:
\itemize{
\item \code{"QUERCUS_SP"}, \code{"QUERCUS_ROBUR"}, \code{"QUERCUS_PETRAEA"},
\code{"QUERCUS_PUBESCENS"}, \code{"QUERCUS_RUBRA"}
\item \code{"FAGUS_SYLVATICA"}, \code{"ACER_PSEUDOPLATANUS"},
\code{"FRAXINUS_EXCELSIOR"}, \code{"ULMUS_SP"}, \code{"PRUNUS_AVIUM"}
\item \code{"BETULA_SP"}, \code{"ALNUS_GLUTINOSA"}, \code{"LARIX_SP"},
\code{"PINUS_SYLVESTRIS"}, \code{"CRATAEGUS_SP"}
\item \code{"PRUNUS_SP"}, \code{"CARPINUS_SP"}, \code{"CASTANEA_SATIVA"},
\code{"CORYLUS_AVELLANA"}, \code{"MALUS_SP"}
\item \code{"PYRUS_SP"}, \code{"SORBUS_ARIA"}, \code{"SAMBUCUS_SP"},
\code{"RHAMNUS_FRANGULA"}, \code{"PRUNUS_CERASUS"}
\item \code{"ALNUS_INCANA"}, \code{"POPULUSxCANADENSIS"},
\code{"POPULUS_TREMULA"}, \code{"PINUS_NIGRA"}, \code{"PINUS_LARICIO"}
\item \code{"TAXUS_BACCATA"}, \code{"ACER_PLATANOIDES"},
\code{"ACER_CAMPESTRE"}, \code{"SORBUS_AUCUPARIA"}, \code{"JUNGLANS_SP"}
\item \code{"TILLIA_SP"}, \code{"AESCULUS_HIPPOCASTANUM"},
\code{"ROBINIA_PSEUDOACACIA"}, \code{"SALIX_SP"}
}
}

\examples{
df <- data.frame(
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA"),
  c150 = c(145, NA),
  c130 = c(NA, 156)
)
c150_c130(df)

}
\seealso{
\code{\link{c150_c130_coeff}} for species-specific coefficients.
}
