% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_models.R
\name{subset_models}
\alias{subset_models}
\title{Subset \code{GHRmodels} Objects}
\usage{
subset_models(models, mod_id, new_name = NULL)
}
\arguments{
\item{models}{A \code{GHRmodels} object.}

\item{mod_id}{A character vector of model IDs indicating which model(s)
to keep. These must match \code{models$mod_gof$model_id}.}

\item{new_name}{\code{NULL} (default) \strong{or} a character used to build the new
model IDs.}
}
\value{
A new \code{GHRmodels} object containing only the specified model(s).
}
\description{
This function subsets selected models from a \code{GHRmodels} object into a new
reduced \code{GHRmodels} object.
}
\examples{
\donttest{
# Load example GHRmodels object from the package: 
model_list_file <- system.file("examples", "model_list.rds", package = "GHRmodel")
model_list <- readRDS(model_list_file)

# Extract a vector with the moded IDs of the 2 best fitting models by WAIC
best_waic <- rank_models(
  models = model_list,  # GHRmodels object containing model fit results
  metric = "waic",      # Metric used to rank models (lower WAIC is better)
  n = 2                 # Number of top-ranked models to return
)

# The output is a vector 
best_waic

# Subset those specific models and assign new IDs
model_waic <- subset_models(
  model = model_list,
  mod_id = best_waic,
  new_name = "best_waic"
)

# Check output subset model names
model_waic$mod_gof$model_id  
}

}
\seealso{
\code{\link{stack_models}} for combining GHRmodels objects,
\code{\link{fit_models}} for fitting INLA models.
}
