% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GINAX.R
\name{GINAX}
\alias{GINAX}
\title{Performs GINA-X as described in the manuscript, Xu, Williams, Tegge, and Ferreira Genome-wide iterative fine-mapping for non-Gaussian data, Nature Genetics, Submitted.}
\usage{
GINAX(
  Y,
  Covariance,
  SNPs,
  family,
  Z = NULL,
  offset = NULL,
  FDR_Nominal = 0.05,
  maxiterations = 2000,
  runs_til_stop = 400
)
}
\arguments{
\item{Y}{The observed phenotypes, count or binary.}

\item{Covariance}{A list of covariance matrices that are the covariance matrices of the random effects. This matches the list of design matrices in Z.}

\item{SNPs}{The SNP matrix, where each column represents a single SNP encoded as the numeric coding 0, 1, 2. This is entered as a matrix object.}

\item{family}{Specify if the response is count ("poisson") or binary ("bernoulli").}

\item{Z}{A list of matrices specifying the design matrix of each random effect of interest.}

\item{offset}{If family = "poisson", the offset of each ecotype, can be a vector or a number if the number of offset is the same for each ecotype. If family = "binomial", offset = NULL.}

\item{FDR_Nominal}{The nominal false discovery rate for which SNPs are selected from in the screening step.}

\item{maxiterations}{The maximum iterations the genetic algorithm in the model selection step iterates for, defaulted at 2000}

\item{runs_til_stop}{The number of iterations at the same best model before the genetic algorithm in the model selection step converges, defaulted at 400}
}
\value{
The column indices of SNPs that were in the best model identified by GINAX
}
\description{
Performs GINA-X as described in the manuscript, Xu, Williams, Tegge, and Ferreira Genome-wide iterative fine-mapping for non-Gaussian data, Nature Genetics, Submitted.
}
\examples{
data("Y_binary");data("SNPs");data("kinship")
n <- length(Y_binary)
covariance <- list()
covariance[[1]] <- kinship
\dontrun{
output_binary <- GINAX(Y=Y_binary, SNPs=SNPs,
                   Covariance=covariance, Z=NULL, family="bernoulli",
                   offset=NULL, FDR_Nominal = 0.05,
                  maxiterations = 1000, runs_til_stop = 200)
}
}
