% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{com.prdist}
\alias{com.prdist}
\title{Compute generalized L-moment distance probabilities}
\usage{
com.prdist(
  data = NULL,
  numk = NULL,
  kfix = NULL,
  Vinv = NULL,
  detV = NULL,
  numom = NULL,
  hosking = NULL,
  trim = NULL,
  cov.type = "lambda"
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{numk}{Number of candidate submodels.}

\item{kfix}{List of submodel fitting results.}

\item{Vinv}{Inverse of the L-moment covariance matrix.}

\item{detV}{Determinant of the L-moment covariance matrix.}

\item{numom}{Number of L-moments.}

\item{hosking}{List containing LME results.}

\item{trim}{Left trimming level.}

\item{cov.type}{Covariance type: "ratio" or "lambda" (default "lambda").}
}
\value{
A list containing:
\describe{
  \item{prob.mtx}{Matrix (numk x 2) of probabilities (col 1 = gLd, col 2 = med)}
  \item{gdd}{Matrix (numk x 2) of generalized distances}
}
}
\description{
Internal function that computes generalized L-moment distance
and median-based distance probabilities for each candidate submodel.
}
\keyword{internal}
