% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgev.R
\name{gado.prop_11}
\alias{gado.prop_11}
\title{Comprehensive Non-stationary GEV Estimation}
\usage{
gado.prop_11(xdat, ntry = 20, ftol = 1e-06)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted.}

\item{ntry}{Number of attempts for optimization (default 20).}

\item{ftol}{Function tolerance for optimization (default 1e-6).}
}
\value{
A list containing:
\itemize{
  \item \code{para.prop} - L-moment based estimates (proposed method).
  \item \code{para.gado} - GN16 method estimates.
  \item \code{para.wls} - Weighted least squares estimates.
  \item \code{strup.org} - Original non-stationary WLSE by Strup method.
  \item \code{lme.sta} - Stationary L-moment estimates.
}
}
\description{
Estimates parameters of a non-stationary GEV distribution using multiple methods:
Weighted Least Squares (WLS), GN16 method, and the proposed L-moment method
from Shin et al. (2025, J. Korean Stat. Soc.).

This is a convenience wrapper around \code{\link{glme.gev11}} with \code{pen="no"},
providing compatibility with the original nsgev package interface.
}
\examples{
data(Trehafod)
result <- gado.prop_11(Trehafod$r1, ntry = 5)
print(result$para.prop)
print(result$lme.sta)

}
\references{
Shin, Y., Shin, Y. & Park, J.-S. (2025). Building nonstationary extreme value
model using L-moments. Journal of the Korean Statistical Society, 54, 947-970.
\doi{10.1007/s42952-025-00325-3}
}
\seealso{
\code{\link{glme.gev11}} for the full GLME method with penalty functions,
  \code{\link{nsgev}} for the simple interface.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
