% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{haenam}
\alias{haenam}
\title{Haenam Maximum Rainfall Data}
\format{
A data frame with 52 rows and 2 columns:
\describe{
  \item{year}{Year of observation (integer, 1971-2022)}
  \item{X1}{Annual maximum daily rainfall in mm (numeric)}
}
}
\source{
Korea Meteorological Administration (KMA; \url{https://www.weather.go.kr})
}
\usage{
haenam
}
\description{
Annual maximum daily rainfall data from Haenam, South Korea.
This dataset is used for demonstrating model averaging methods
for high quantile estimation in extreme value analysis.
}
\examples{
data(haenam)
head(haenam)

# Estimate high quantiles using model averaging
result <- ma.gev(haenam$X1, quant = c(0.98, 0.99, 0.995))
print(result$qua.ma)

}
\references{
Shin, Y., Shin, Y., & Park, J. S. (2026). Model averaging with mixed criteria
for estimating high quantiles of extreme values: Application to heavy rainfall.
\emph{Stochastic Environmental Research and Risk Assessment}, 40(2), 47.
\doi{10.1007/s00477-025-03167-x}
}
\keyword{datasets}
