% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{optim.glme.gev11}
\alias{optim.glme.gev11}
\title{Multi-start optimization for GEV11 model}
\usage{
optim.glme.gev11(
  xdat,
  ntry = 10,
  ftol = 1e-06,
  pretheta = NULL,
  model = "gev11",
  pen = "beta",
  mu = mu,
  std = std,
  p = p,
  c1 = c1,
  c2 = c2,
  choose = NULL
)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{ntry}{Number of random starting points. Default is 10.}

\item{ftol}{Tolerance for convergence. Default is 1e-6.}

\item{pretheta}{Pre-estimated parameter vector (mu0, mu1, sigma0, sigma1, xi).}

\item{model}{Model type: "gev11" (default), "gev10", or "gev20".}

\item{pen}{Penalty type: "beta" (default), "norm", "ms", "park", "cannon", "cd", or "no".}

\item{mu}{Normal penalty mean.}

\item{std}{Normal penalty standard deviation.}

\item{p}{Beta penalty shape parameter.}

\item{c1}{Beta penalty scaling parameter.}

\item{c2}{Beta penalty limit parameter.}

\item{choose}{Selection method: "gof" (goodness-of-fit) or "nllh".}
}
\value{
A list containing:
\describe{
  \item{para.lme}{L-moment based estimates (5 parameters)}
  \item{precis}{Precision of the best solution}
  \item{para.glme}{GLME estimates (if pen != "no")}
  \item{nllh.glme}{Penalized negative log-likelihood (if pen != "no")}
  \item{pen}{Penalty type used}
}
}
\description{
Internal function that performs multi-start optimization
for the non-stationary GEV11 model. First solves L-moment equations
via nleqslv (Broyden method), then optionally refines with penalized
optimization via optim. Selects the best solution using goodness-of-fit
or penalized negative log-likelihood.
}
\keyword{internal}
