% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{wlik.xifix}
\alias{wlik.xifix}
\title{Likelihood-based weights with fixed xi}
\usage{
wlik.xifix(
  data = NULL,
  numk = NULL,
  kpar = NULL,
  weight = NULL,
  pertr = 0.85,
  varcom = FALSE,
  type = NULL,
  prior = NULL,
  trim = NULL
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{numk}{Number of candidate submodels.}

\item{kpar}{Numeric vector of candidate xi values.}

\item{weight}{Weighting method name.}

\item{pertr}{Perturbation parameter (default 0.85).}

\item{varcom}{Logical. Whether to compute variance (default FALSE).}

\item{type}{Type of computation.}

\item{prior}{Numeric vector of BMA prior values.}

\item{trim}{Left trimming level.}
}
\value{
A list containing:
\describe{
  \item{bmaw}{BMA weight vector}
  \item{wt}{MA weight vector}
  \item{aic}{AIC values for each submodel}
  \item{kfix}{Matrix (3 x numk) of submodel parameters}
  \item{cov2}{List of 2x2 covariance matrices (if varcom=TRUE)}
}
}
\description{
Internal function that computes AIC-based model averaging
weights using the profile likelihood with L-moment submodel estimates
for each candidate xi.
}
\keyword{internal}
