compute_loglik <- function(x, params) {
  # params must contain pi, mu, sigma
  # your density function might differ (Gaussian shown here)
  # compute_loglik(x, params = res)
  k <- length(params$pi)
  n <- nrow(x)
  
  dens <- matrix(0, n, k)
  for (j in 1:k) {
    dens[, j] <- params$pi[j] * dmvnorm(x, mean = params$mu[j,], sigma = params$sigma[,,j])
  }
  
  return(sum(log(rowSums(dens))))
}


getBestInit <- function(x, k,
                        init_methods = c("Random", "emEM", "emAEM",
                                         "hierarchical average", "hierarchical ward",
                                         "kmeans", "mclust", "cem", "sem"),
                        run_number = 10, max_iter = 3, tol = 1e-6, burn_in = 3,
                        verbose = FALSE) {
  
  .msg <- function(...) {
    if (isTRUE(verbose)) message(...)
  }
  
  results <- vector("list", length(init_methods))
  names(results) <- init_methods
  ll_values <- rep(NA_real_, length(init_methods))
  
  for (i in seq_along(init_methods)) {
    m <- init_methods[i]
    .msg("Running method: ", m)
    
    res <- getInit(x, k, method = m,
                   run_number = run_number,
                   max_iter = max_iter,
                   tol = tol,
                   burn_in = burn_in)
    
    results[[m]] <- res
    
    # compute log-likelihood 
    ll_values[i] <- compute_loglik(x, res)
  }
  
  names(ll_values) <- init_methods
  
  if (all(is.na(ll_values))) {
    stop("All methods produced NA log-likelihood; cannot select best initialization.")
  }
  
  best_idx <- which.max(ll_values)
  best_method <- init_methods[best_idx]
  best_result <- results[[best_method]]
  
  .msg("Best method: ", best_method, " with log-likelihood = ", ll_values[best_idx])
  
  out <- list(
    best_method = best_method,
    best_result = best_result,
    loglik_table = data.frame(method = init_methods, loglik = ll_values)
  )
  # class(out) <- "gmminit_bestinit"
  out
}

