% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_game.R
\name{restart_sg}
\alias{restart_sg}
\title{Restart existing run}
\usage{
restart_sg(
  results,
  fun,
  ...,
  equilibrium = "NE",
  crit = "sur",
  n.ite,
  x.to.obj = NULL,
  noise.var = NULL,
  Nadir = NULL,
  Shadow = NULL,
  integcontrol = NULL,
  simucontrol = NULL,
  filtercontrol = NULL,
  kmcontrol = NULL,
  returncontrol = NULL,
  ncores = 1,
  trace = 1,
  seed = NULL
)
}
\arguments{
\item{results}{output of \code{\link[GPGame]{solve_game}} that is to be continued}

\item{fun}{fonction with vectorial output}

\item{...}{additional parameter to be passed to fun}

\item{equilibrium}{either '\code{NE}', '\code{KSE}', '\code{CKSE}' or '\code{NKSE}' for Nash / Kalai-Smorodinsky / Copula-Kalai-Smorodinsky / Nash-Kalai-Smorodinsky equilibria}

\item{crit}{'\code{sur}' (default) is available for all equilibria, '\code{psim}' and '\code{pex}' are available for Nash}

\item{n.ite}{number of additional iterations of sequential optimization}

\item{x.to.obj}{for NE and NKSE, which variables for which objective}

\item{noise.var}{noise variance. Either a scalar (same noise for all objectives), a vector (constant noise, different for each objective), a function (type closure) with vectorial output (variable noise, different for each objective) or "given_by_fn", see Details. If not provided, noise.var is taken as the average of model@noise.var.}

\item{Nadir, Shadow}{optional vectors of size nobj. Replaces the nadir or shadow point for KSE. If only a subset of values needs to be defined, the other coordinates can be set to Inf (resp. -Inf for the shadow).}

\item{integcontrol}{optional list for handling integration points. See Details.}

\item{simucontrol, filtercontrol, kmcontrol, returncontrol}{see \code{\link[GPGame]{solve_game}}}

\item{ncores}{number of CPU available (> 1 makes mean parallel TRUE)}

\item{trace}{controls the level of printing: 0 (no printing), 1 (minimal printing), 3 (detailed printing)}

\item{seed}{to fix the random variable generator}
}
\value{
See \code{\link[GPGame]{solve_game}}.
}
\description{
Wrapper around \code{\link[GPGame]{solve_game}} to add iterations to an existing run
}
\details{
Unless given new values, restart_sg reuses values stored in results (e.g., \code{integcontrol}).
}
\note{
For beta testing, this function could evolve.
}
