% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_initialize}
\alias{galaxy_initialize}
\alias{galaxy_initialize,missing-method}
\alias{galaxy_initialize,Galaxy-method}
\title{Create a new Galaxy history}
\usage{
galaxy_initialize(
  x,
  name = "R API request",
  galaxy_url = "https://usegalaxy.eu"
)

\S4method{galaxy_initialize}{missing}(name, galaxy_url)

\S4method{galaxy_initialize}{Galaxy}(x)
}
\arguments{
\item{x}{A \code{Galaxy} object, or missing to use the default method.}

\item{name}{Name of the history to create. Ignored when \code{x} is a
\code{Galaxy}, in which case \code{x@history_name} is used.}

\item{galaxy_url}{Base URL of the Galaxy instance. Ignored when \code{x} is a
\code{Galaxy}, in which case \code{x@galaxy_url} is used.}
}
\value{
For the default method (\code{x} missing), a character scalar history ID.
For the \code{Galaxy} method, the modified \code{Galaxy} object.
}
\description{
\code{galaxy_initialize()} is an S4 generic. With no \code{x} supplied it creates a
new history on the given Galaxy instance and returns its encoded ID. When
called with a \code{Galaxy} object it uses the object’s \code{history_name} and
\code{galaxy_url}, creates the history, and updates the object with the new
\code{history_id} and state \code{"pending"}.
}
\details{
A valid Galaxy API key is required and must be available via the
\code{GALAXY_API_KEY} environment variable.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
history_id <- galaxy_initialize("My history name")
g <- galaxy(history_name = "My history name")
g <- galaxy_initialize(g)
\dontshow{\}) # examplesIf}
}
