\name{gsom_predict}
\alias{gsom_predict}
\title{Predict BMUs for new data using a fitted Gower-SOM}
\description{
Maps new observations to their Best Matching Units (BMUs) using the
codebook and grid stored in a fitted \code{gowersom} object.
}
\usage{
gsom_predict(object, newdata, ...)
}
\arguments{
  \item{object}{A \code{gowersom} object returned by \code{gsom_Training()}.}
  \item{newdata}{A \code{data.frame} of new observations to map.
  Must be typed consistently with the training data (numeric, factor, etc.).}
  \item{...}{Additional arguments passed to internal functions (not used).}
}
\value{
A \code{data.frame} with the following columns:
\describe{
  \item{bmu}{Integer BMU index (1 .. n_rows * n_cols).}
  \item{distance}{Numeric Gower distance to the BMU.}
  \item{row}{Integer, BMU grid row coordinate.}
  \item{col}{Integer, BMU grid column coordinate.}
}
}
\details{
This function is a convenience wrapper around \code{\link{get_bmu_gower}}.
It automatically extracts the grid dimensions from \code{object\$coords}
and applies BMU mapping for each observation in \code{newdata}.
}

\author{
  Patricio Sáez <patricsaez@udec.cl>;
  Patricio Salas <patricioasalas@udec.cl>
}

\references{
Sáez, P., Salas, P. Gower-SOM: a self-organizing map for mixed data with gower distance and heuristic adaptation for data analytics. Int J Data Sci Anal 22, 26 (2026). https://doi.org/10.1007/s41060-025-00941-6/."
}

\examples{
set.seed(1)
df <- data.frame(
  x1 = rnorm(20),
  x2 = rnorm(20),
  g  = factor(sample(letters[1:3], 20, TRUE))
)
fit <- gsom_Training(df, grid_rows = 3, grid_cols = 3,
                num_iterations = 5, batch_size = 4)

# Map observations to BMUs
pred <- gsom_predict(fit, df)
head(pred)
}
\seealso{\code{\link{get_bmu_gower}}}
