% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{plot_obj_val_by_iter}
\alias{plot_obj_val_by_iter}
\title{Plots the objective value by iteration}
\usage{
plot_obj_val_by_iter(res, runs = NULL)
}
\arguments{
\item{res}{Results from a greedy search object}

\item{runs}{A vector of run indices you would like to see plotted (default is to plot the first up to 9)}
}
\description{
Plots the objective value by iteration
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(20), nrow = 10)
ged = initGreedyExperimentalDesignObject(
  X,
  max_designs = 5,
  num_cores = 1,
  diagnostics = TRUE,
  objective = "abs_sum_diff",
  start = TRUE,
  wait = TRUE,
  verbose = FALSE
)
res = resultsGreedySearch(ged, max_vectors = 2)
plot_obj_val_by_iter(res)
}
}
\author{
Adam Kapelner
}
