\name{weekly_maxima}
\docType{data}
\alias{weekly_maxima}
\title{Weekly maxima of geomagnetic rate-of-change data from Eskdalemuir Magnetic Observatory}
\description{
A dataset containing weekly block maxima of the horizontal geomagnetic field rate-of-change
at the Eskdalemuir Magnetic Observatory, Scotland, United Kingdom.
These data quantify the variability of the Earth's magnetic field and capture periods
of extreme geomagnetic disturbance from 1999 to 2022.
}
\usage{data(weekly_maxima)}
\format{
A numeric vector of weekly maxima of
\deqn{R_1(t) = \sqrt{(X_t - X_{t-1})^2 + (Y_t - Y_{t-1})^2},}
where \eqn{X_t} and \eqn{Y_t} are the horizontal north and east components
of the Earth's magnetic field, respectively, measured at one-minute intervals.
}
\details{
Aggregating to a weekly scale smooths out short-lived fluctuations while retaining the
most significant geomagnetic disturbances, as well as reducing short-term serial dependencies.
The extreme nature of the data motivates modelling via the Generalised Extreme Value (GEV)
distribution, with density
\deqn{f(x) = \frac{1}{\sigma}
    \left[1+\xi\left(\frac{x-\mu}{\sigma}\right)\right]^{-\frac{1}{\xi}-1}
    \exp\left\{-\left[1+\xi\left(\frac{x-\mu}{\sigma}\right)\right]^{-\frac{1}{\xi}}\right\},}
where \eqn{\mu}, \eqn{\sigma}, and \eqn{\xi} are the location, scale, and shape parameters, respectively.
}
\source{
Eskdalemuir Magnetic Observatory, British Geological Survey, United Kingdom.

Derived and aggregated for use in \pkg{HMMHSMM}.
}
\examples{
data(weekly_maxima)
hist(weekly_maxima, breaks = 30, main = "Weekly maxima of geomagnetic variability",
     xlab = "Weekly maximum rate of change (nT/min)")
}

