% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeNovelty.R
\name{removeNovelty}
\alias{removeNovelty}
\title{Remove identified novelty cell(s)}
\usage{
removeNovelty(outlier_cells, hvt_results)
}
\arguments{
\item{outlier_cells}{Vector. A vector with the cell number of the identified novelty}

\item{hvt_results}{List. A list having the results of the compressed map i.e. output of \code{trainHVT} function}
}
\value{
A list of two items
\item{[[1]] }{Dataframe of novelty cell(s)}
\item{[[2]] }{Dataframe without the novelty cell(s) from the dataset used in model training}
}
\description{
This function is used to remove the identified novelty cells.
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans")
identified_Novelty_cells <<- c(2, 10)
output_list <- removeNovelty(identified_Novelty_cells, hvt.results) 
data_with_novelty <- output_list[[1]]
data_without_novelty <- output_list[[2]]                      
}
\seealso{
\code{\link{trainHVT}} \cr \code{\link{scoreLayeredHVT}}
}
\author{
Shantanu Vaidya <shantanu.vaidya@mu-sigma.com>
}
\keyword{Novelty_or_Outliers}
