% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_p_diff_uptake_dataset_with_confidence.R
\name{create_p_diff_uptake_dataset_with_confidence}
\alias{create_p_diff_uptake_dataset_with_confidence}
\title{Create differential dataset with statistical validity}
\usage{
create_p_diff_uptake_dataset_with_confidence(
  p_diff_uptake_dat,
  houde_interval = NULL,
  houde_interval_times = NULL,
  theoretical = FALSE,
  fractional = FALSE
)
}
\arguments{
\item{p_diff_uptake_dat}{differential uptake data 
alongside the P-value as calculated by 
\code{\link{create_p_diff_uptake_dataset}}}

\item{houde_interval}{interval value, as calculated by
\code{\link{calculate_confidence_limit_values}}}

\item{houde_interval_times}{specified time points to 
be used in calculation}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{fractional}{\code{logical}, determines if values are fractional}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Create differential dataset with statistical validity
}
\details{
Function provides additional information 
on statistical relevance based on supplied data.
}
\examples{
p_diff_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
p_diff_uptake_dat_confidence <- create_p_diff_uptake_dataset_with_confidence(p_diff_uptake_dat)
head(p_diff_uptake_dat_confidence)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_p_diff_uptake_dataset}}
\code{\link{calculate_confidence_limit_values}}
}
