% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_protein_coverage}
\alias{get_protein_coverage}
\title{Get protein coverage}
\usage{
get_protein_coverage(
  dat,
  protein = dat[["Protein"]][1],
  states = unique(dat[["State"]]),
  protein_length = NULL
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{states}{selected biological states}

\item{protein_length}{\code{\link{numeric}}, indicates the length of 
the protein. If not provided, the maximal end value from the file is used.}
}
\value{
a \code{\link{numeric}} percentage value (rounded to two decimal places).
}
\description{
Calculate protein coverage by the peptides in 
selected biological state or states.
}
\details{
Function \code{\link{get_protein_coverage}} calculates the 
percentage coverage of the protein sequence, rounded to two decimal places.
}
\examples{
get_protein_coverage(alpha_dat)
get_protein_coverage(alpha_dat, protein_length = 230)

}
\seealso{
\code{\link{read_hdx}}
}
