% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_uptake_structure.R
\name{plot_aggregated_uptake_structure}
\alias{plot_aggregated_uptake_structure}
\title{Plot aggregated uptake on the 3D structure}
\usage{
plot_aggregated_uptake_structure(
  aggregated_dat,
  differential = FALSE,
  fractional = TRUE,
  theoretical = FALSE,
  time_t,
  pdb_file_path
)
}
\arguments{
\item{aggregated_dat}{aggregated data, either for single uptake or differential}

\item{differential}{indicator if the aggregated_dat contains differential 
results}

\item{fractional}{indicator if fractional values are used}

\item{theoretical}{indicator if theoretical values are used}

\item{time_t}{time point from aggregated_dat to be shown on the structure}

\item{pdb_file_path}{file path to the pdb file}
}
\value{
a r3dmol object.
}
\description{
Function plots the aggregated data (either one state deuterium uptake or
differential deuterium uptake) on the 3d structure.
}
\examples{
\donttest{
library(shiny)
# disabled due to its long time and producing 3rdmol object

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
diff_aggregated_dat <- create_aggregated_diff_uptake_dataset(diff_uptake_dat)
pdb_file_path <- system.file(package = "HaDeX2", "HaDeX/data/Model_eEF1Balpha.pdb")

plot_aggregated_uptake_structure(diff_aggregated_dat,
                                differential = TRUE,
                                 time_t = 1,
                                 pdb_file_path = pdb_file_path)

kin_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN" )
aggregated_dat <- create_aggregated_uptake_dataset(kin_dat)
plot_aggregated_uptake_structure(aggregated_dat,
                                 differential = FALSE,
                                 time_t = 1,
                                 pdb_file_path = pdb_file_path) 
}

}
