% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_butterfly.R
\name{plot_butterfly}
\alias{plot_butterfly}
\title{Butterfly deuterium uptake plot}
\usage{
plot_butterfly(
  uptake_dat,
  theoretical = FALSE,
  fractional = FALSE,
  uncertainty_type = "ribbon",
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{uptake_dat}{data produced by \code{\link{create_state_uptake_dataset}} 
function.}

\item{theoretical}{\code{logical}, determines if values are theoretical.}

\item{fractional}{\code{logical}, determines if values are fractional.}

\item{uncertainty_type}{type of presenting uncertainty, possible values:
"ribbon", "bars" or "bars + line".}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Butterfly plot of deuterium uptake values in time
for one biological state.
}
\details{
Function \code{\link{plot_butterfly}} generates butterfly plot
based on provided data and parameters. On X-axis there is peptide ID. On the Y-axis
there is deuterium uptake in chosen form. Data from multiple time points of 
measurement is presented.
}
\examples{
state_uptake_dat <- create_state_uptake_dataset(alpha_dat)
plot_butterfly(state_uptake_dat)

}
\seealso{
\code{\link{create_state_uptake_dataset}}
}
