% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_differential_uptake_curve.R
\name{plot_differential_uptake_curve}
\alias{plot_differential_uptake_curve}
\title{Plot differential uptake curve}
\usage{
plot_differential_uptake_curve(
  diff_uptake_dat = NULL,
  diff_p_uptake_dat = NULL,
  sequence = NULL,
  theoretical = FALSE,
  fractional = FALSE,
  uncertainty_type = "ribbon",
  log_x = TRUE,
  show_houde_interval = FALSE,
  show_tstud_confidence = FALSE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{diff_uptake_dat}{produced by \code{\link{calculate_diff_uptake}} or
\code{\link{create_diff_uptake_dataset}} function}

\item{diff_p_uptake_dat}{differential uptake data 
alongside the P-value as calculated by 
\code{\link{create_p_diff_uptake_dataset}}}

\item{sequence}{sequence of chosen peptide}

\item{theoretical}{\code{logical}, determines if plot shows theoretical values}

\item{fractional}{\code{logical}, determines if plot shows fractional values}

\item{uncertainty_type}{type of presenting uncertainty, possible values:
"ribbon", "bars" or "bars + line"}

\item{log_x}{\code{logical}, determines if x axis shows logarithmic values}

\item{show_houde_interval}{\code{logical}, determines if houde interval is shown}

\item{show_tstud_confidence}{\code{logical}, determines if t-Student test validity 
is shown}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Differential uptake curve for one peptide
between two biological states.
}
\details{
This plot shows the differential deuterium uptake between two biological 
states for selected peptides in different time points.
The possibility to plot multiple differences (between state and mutant) for the peptide
will be added soon.
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
plot_differential_uptake_curve(diff_uptake_dat = diff_uptake_dat, sequence = "GDLKSPAGL")

diff_p_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
plot_differential_uptake_curve(diff_p_uptake_dat = diff_p_uptake_dat, 
                               sequence = "GDLKSPAGL", show_houde_interval = TRUE)
plot_differential_uptake_curve(diff_p_uptake_dat = diff_p_uptake_dat, 
                               sequence = "GDLKSPAGL", show_houde_interval = TRUE, 
                               show_tstud_confidence = TRUE)
plot_differential_uptake_curve(diff_p_uptake_dat = diff_p_uptake_dat, 
                               sequence = "GDLKSPAGL", show_tstud_confidence = TRUE)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_diff_uptake_dataset}}
\code{\link{calculate_diff_uptake}}
}
