% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_aggregated_uptake_dataset.R
\name{show_aggregated_uptake_data}
\alias{show_aggregated_uptake_data}
\title{Show aggregated values in friendly form}
\usage{
show_aggregated_uptake_data(
  aggregated_dat,
  differential = FALSE,
  fractional = TRUE,
  theoretical = FALSE
)
}
\arguments{
\item{aggregated_dat}{aggregated uptake data}

\item{differential}{indicator if the aggregated_dat is 
single-state or differential}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{theoretical}{\code{logical}, determines if values are theoretical}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Function plots the aggregated uptake data
with regard to submitted parameters in a friendly form.
Designed for GUI.
}
\examples{
\donttest{
# disabled due to long execution time 

kin_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN")
aggregated_dat <- create_aggregated_uptake_dataset(kin_dat)
show_aggregated_uptake_data(aggregated_dat)

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
aggregated_diff_dat <- create_aggregated_diff_uptake_dataset(diff_uptake_dat)
show_aggregated_uptake_data(aggregated_diff_dat, differential = TRUE)
}

}
