% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indonesia_gdp.R
\name{get_indonesia_gdp}
\alias{get_indonesia_gdp}
\title{Get Indonesia's GDP (Current US$) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/NY.GDP.MKTP.CD}
}
\usage{
get_indonesia_gdp()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "GDP (current US$)")
  \item \code{country}: Country name ("Indonesia")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: GDP value in numeric form
  \item \code{value_label}: Formatted GDP value (e.g., "1,466,464,899,304")
}
Returns \code{NULL} if the API is unavailable or returns an error.
}
\description{
Retrieves Indonesia's Gross Domestic Product (GDP) in current US dollars
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{NY.GDP.MKTP.CD}.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
\donttest{
get_indonesia_gdp()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}, \code{\link[scales]{comma}}
}
