#' KWELA: Hierarchical Adaptive RT-QuIC Classification
#'
#' @description
#' Extends RT-QuIC (Real-Time Quaking-Induced Conversion) statistical analysis
#' to complex environmental matrices through hierarchical adaptive classification.
#' KWELA is named after a deity of the Fore people of Papua New Guinea, among
#' whom Kuru, a notable human prion disease, was identified.
#'
#' @section 6-Layer Architecture:
#' \describe{
#'   \item{Layer 1: Hard Gate}{Biological constraint filter}
#'   \item{Layer 2: Per-Well Scoring}{Profile-dependent adaptive transforms}
#'   \item{Layer 3: Adaptive Combination}{Separation-aware score combiner}
#'   \item{Layer 4: Adaptive Cutoff}{Youden-optimized threshold}
#'   \item{Layer 5: Replicate Consensus}{Treatment-level classification}
#'   \item{Layer 6: Instability Detection}{Matrix interference override}
#' }
#'
#' @section Dual-Mode Operation:
#' \describe{
#'   \item{diagnostic}{Default mode. Deterministic classification from
#'     TTT/MP/RAF evidence only. No stochastic rescue or score blending.}
#'   \item{research}{Full adaptive architecture with stochastic rescue
#'     and distributional scoring.}
#' }
#'
#' @section Main Functions:
#' \describe{
#'   \item{\code{\link{kwela_analyze}}}{Main analysis function}
#'   \item{\code{\link{kwela_summarize}}}{Treatment-level summary}
#'   \item{\code{\link{kwela_diagnostics}}}{Diagnostic information}
#'   \item{\code{\link{compute_instability_flags}}}{Matrix instability detection}
#' }
#'
#' @section Plate/Batch Functions:
#' \describe{
#'   \item{\code{\link{kwela_plate_normalize}}}{Multi-plate normalization}
#'   \item{\code{\link{kwela_bootstrap_summary}}}{Bootstrap confidence intervals}
#' }
#'
#' @section Profiles:
#' \describe{
#'   \item{standard}{Strong separation, clean assay (Cohen's d > 3)}
#'   \item{sensitive}{Moderate separation, spiked samples (d 1.5-3)}
#'   \item{matrix_robust}{Poor separation, matrix interference (d < 1.5)}
#'   \item{auto}{Auto-selects based on separation quality}
#' }
#'
#' @section Consensus Rules:
#' \describe{
#'   \item{strict}{All wells must be positive}
#'   \item{majority}{>50% of wells positive}
#'   \item{flexible}{Any well positive}
#'   \item{threshold}{Mean score >= threshold}
#' }
#'
#' @docType package
#' @name KWELA-package
#' @aliases KWELA
"_PACKAGE"
