% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_python_dependencies.R
\name{install_python_dependencies}
\alias{install_python_dependencies}
\title{Install Required Python Dependencies for Neural Latent Variable Models}
\usage{
install_python_dependencies()
}
\value{
A named list of logical values indicating whether each package was already installed before running this function:
\item{numpy_installed}{Logical. Was \code{numpy} already available?}
\item{torch_installed}{Logical. Was \code{torch} already available?}
\item{matplotlib_installed}{Logical. Was \code{matplotlib} already available?}
\item{sklearn_installed}{Logical. Was \code{scikit-learn} already available?}
\item{scipy_installed}{Logical. Was \code{scipy} already available?}
}
\description{
Checks whether five essential Python packages required to run neural latent variable models
(e.g., LCAnet, LPAnet) are installed in the current Python environment. If any are missing,
the user is interactively prompted to install them via \code{reticulate::py_install()}.
The targeted packages are:
\itemize{
\item \code{numpy} — Fundamental package for numerical computing in Python.
\item \code{torch} — PyTorch deep learning framework (supports CPU/GPU computation).
\item \code{matplotlib} — 2D plotting and visualization library.
\item \code{scikit-learn} — Machine learning utilities (used here primarily for KMeans initialization).
\item \code{scipy} — Scientific computing and advanced linear algebra routines.
}

For \code{torch}, users can choose between CPU-only or GPU-enabled versions (with CUDA support).
Available CUDA versions are filtered by OS compatibility.

This function is especially useful when deploying models that bridge R and Python via \pkg{reticulate},
ensuring all backend dependencies are met before model execution.
}
\details{
The function performs the following steps for each dependency:
\enumerate{
\item Uses \code{reticulate::py_module_available()} to test if the module is importable.
\item If not available, prints a message describing the package’s purpose.
\item Prompts the user interactively (via \code{readline}) whether to proceed with installation.
\item For \code{torch}, offers CPU/GPU choice and CUDA version selection if GPU is chosen.
\item Installs the package using \code{reticulate::py_install()} with appropriate index URL if needed.
\item Returns a logical list indicating initial installation status of each package.
}

\strong{Note:} This function requires \pkg{reticulate} to be loaded and a valid Python environment configured.
It does NOT automatically install \pkg{reticulate} or configure Python — that must be done separately.
}
\examples{
library(reticulate)

# Ensure reticulate is loaded and Python is configured
# need python
\dontrun{
# Run dependency installer
deps <- install_python_dependencies()

# Check which were missing
print(deps)
}

}
