% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_tests.R
\name{gaussian_mu_one_sample}
\alias{gaussian_mu_one_sample}
\title{Test the mean of a gaussian distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
gaussian_mu_one_sample(x, mu, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{mu}{a number indicating the tested value of mu.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the mean of a gaussian distribution.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(100, 0, 1)
gaussian_mu_one_sample(x, 0, "two.sided")

# Null is false
set.seed(1)
x <- rnorm(100, 3, 1)
gaussian_mu_one_sample(x, 0, "greater")
}
