% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blasso_gibbs_2block_wrappers.R
\name{blasso_gibbs_2block_bl}
\alias{blasso_gibbs_2block_bl}
\title{Bayesian lasso Gibbs sampler: 2-block (beta–lambda2) variant}
\usage{
blasso_gibbs_2block_bl(
  vy,
  mX,
  a,
  b,
  u,
  v,
  nsamples,
  lambda_init = 1,
  sigma2_init = 1,
  va_init = NULL,
  verbose = max(1L, floor(nsamples/5)),
  lower = 1e-12,
  upper = 5000
)
}
\arguments{
\item{vy}{Numeric response vector of length n.}

\item{mX}{Numeric design matrix of dimension n x p.}

\item{a, b}{Hyperparameters for the inverse-gamma prior on sigma^2.}

\item{u, v}{Hyperparameters for the prior on lambda^2.}

\item{nsamples}{Integer number of MCMC iterations.}

\item{lambda_init}{Initial value for lambda.}

\item{sigma2_init}{Initial value for sigma^2.}

\item{va_init}{Optional initial values for local shrinkage parameters (length p).}

\item{verbose}{Print progress every \code{verbose} iterations (0 = silent).}

\item{lower, upper}{Bounds used by the slice sampler for lambda^2.}
}
\value{
A list with components:
\describe{
  \item{mBeta}{Matrix of beta draws (nsamples x p).}
  \item{vsigma2}{Vector of sigma^2 draws (length nsamples).}
  \item{vlambda2}{Vector of lambda^2 draws (length nsamples).}
}
}
\description{
Implements a two-block Gibbs sampler for the Bayesian lasso regression model
in which the regression coefficients are updated jointly with the global
shrinkage parameter \eqn{\lambda^2} in one block, while the noise variance and
local shrinkage parameters are updated conditionally in separate steps.
}
\examples{
set.seed(1)
n <- 30; p <- 6
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)
out <- blasso_gibbs_2block_bl(
  vy = y, mX = X,
  a = 1, b = 1, u = 1, v = 1,
  nsamples = 200,
  lambda_init = 1, sigma2_init = 1,
  verbose = 0
)
str(out)

}
