% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.R
\name{nc}
\alias{nc}
\title{Calculate Network Natural Connectivity}
\usage{
nc(adj_matrix)
}
\arguments{
\item{adj_matrix}{Adjacency data frame or matrix. Can be calculated from \code{\link{network_analysis}}}
}
\value{
Numeric value of natural connectivity
}
\description{
Calculate Network Natural Connectivity
}
\examples{
\donttest{
{
  ### Data preparation ###
  data("Two_group")

  ### One input network analysis ###
  network_results <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Base",
    reads = FALSE,
    n = 10,
    threshold = 0.6
  )

  # Convert network results to a data frame for the adjacency matrix
  network_matrix <- as.data.frame(network_results[[3]])  # Complete adjacency matrix

  # Check initial natural connectivity
  nc_initial <- nc(network_matrix)
  print(nc_initial)  # Print the initial natural connectivity
}
}
}
